# pdf2htmlEX 

[![Build Status](https://travis-ci.org/coolwanglu/pdf2htmlEX.png?branch=master)](https://travis-ci.org/coolwanglu/pdf2htmlEX)

A beautiful demo is worth a thousand words:

- **Typography** (fonts): [HTML](http://coolwanglu.github.com/pdf2htmlEX/demo/geneve.html) / [PDF](https://github.com/raphink/geneve_1564/raw/master/geneve_1564.pdf)
- **Cheat Sheet** (math formulas): [HTML](http://coolwanglu.github.com/pdf2htmlEX/demo/cheat.html) / [PDF](http://www.tug.org/texshowcase/cheat.pdf)
- **Scientific Paper** (text and figures): [HTML](http://coolwanglu.github.com/pdf2htmlEX/demo/demo.html) / [PDF](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.148.349&rep=rep1&type=pdf)
- **Full Circle Magazine** (read while downloading): [HTML](http://coolwanglu.github.com/pdf2htmlEX/demo/issue65_en.html) / [PDF](http://dl.fullcirclemagazine.org/issue65_en.pdf)
- **Git Manual** (CJK support): [HTML](http://coolwanglu.github.com/pdf2htmlEX/demo/chn.html) / [PDF](http://files.cnblogs.com/phphuaibei/git%E6%90%AD%E5%BB%BA.pdf)
- [Try your own files](https://github.com/coolwanglu/pdf2htmlEX/wiki/UploadDemo)

[Browser requirements](https://github.com/coolwanglu/pdf2htmlEX/wiki/Browser-Requirements)
 
### Introduction

pdf2htmlEX renders PDF files in HTML, utilizing modern Web technologies.
It aims to provide an accurate rendering, while keeping optimized for Web display.

pdf2htmlEX is best for text-based PDF files, for example scientific papers with complicated formulas and figures.
Text, fonts and formats are natively preserved in HTML such that you can still search and copy.
The generated HTML file is static, with optional features powered by JavaScript.

[Learn more about who and why should use pdf2htmlEX](https://github.com/coolwanglu/pdf2htmlEX/wiki/Introduction)

### Features

* Precise and native text in HTML
* Flexible Output
* Moderate Size
* More PDF stuffs that you love: links, outlines & printing

[Learn more](https://github.com/coolwanglu/pdf2htmlEX/wiki/Feature-List)   
[Compare with others](https://github.com/coolwanglu/pdf2htmlEX/wiki/Comparison)

### Wiki Portals

 * [Wiki Home](https://github.com/coolwanglu/pdf2htmlEX/wiki)
 * [Download](https://github.com/coolwanglu/pdf2htmlEX/wiki/Download)
 * [Building](https://github.com/coolwanglu/pdf2htmlEX/wiki/Building)
 * [Quick Start](https://github.com/coolwanglu/pdf2htmlEX/wiki/QuickStart)
 * [How to contribute](https://github.com/coolwanglu/pdf2htmlEX/wiki/Contribute)
 * [FAQ](https://github.com/coolwanglu/pdf2htmlEX/wiki/FAQ)

### LICENSE

GPLv3 with additional terms (see below) for most parts, MIT License for `share/*`
                                                     
Read `LICENSE` for more detail.

#### For Online Services

You are free and welcome to modify pdf2htmlEX for your online services, 
but you should credit pdf2htmlEX if your service involves "online conversion" facilitated by pdf2htmlEX.
You are also encouraged to send me a name and a URL for the purpose of statistics.

Read `LICENSE` for more detail.
                                                    
### Resources

* [pdf2htmlEX Blog](http://pdf2htmlex.blogspot.com)
  - News and announcements
  - [RSS Subscribe](http://pdf2htmlex.blogspot.com/feeds/posts/default)
* Mailing list <pdf2htmlex@googlegroups.com>
  - Questions are welcome, but make sure you have read `man pdf2htmlEX` and [wiki](https://github.com/coolwanglu/pdf2htmlEX/wiki)
  - [Subscribe](https://groups.google.com/forum/#!forum/pdf2htmlex)
* Lu Wang <coolwanglu@gmail.com> or [coolwanglu@twitter](https://twitter.com/coolwanglu)
  - For personal enquiries only
  - Accepting messages in **中文**, **English** or **日本語**
* IRC Channel [irc://irc.freenode.net/pdf2htmlEX](irc://irc.freenode.net/pdf2htmlEX)

### Acknowledgements

pdf2htmlEX is made possible thanks to the following projects:

* [poppler](http://poppler.freedesktop.org/)
* [Fontforge](http://fontforge.org/)
* [jQuery](http://jquery.com/)

pdf2htmlEX is inspired by the following projects:

* pdftops & pdftohtml from poppler 
* MuPDF
* PDF.js
* Crocodoc
* Google Doc

#### Special Thanks

* Hongliang Tian
* Wanmin Liu 

